/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl;

import com.ibm.hwmca.fw.fcs.FcsEvent;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rbf.HandlerAlreadyRegisteredException;
import com.ibm.hwmca.fw.rbf.HandlerNotRegisteredException;
import com.ibm.hwmca.fw.rbf.RbfException;
import com.ibm.hwmca.fw.rbf.RbfRequestType;
import com.ibm.hwmca.fw.rbf.impl.CommManager;
import com.ibm.hwmca.fw.rbf.impl.HandlersMsg;
import com.ibm.hwmca.fw.rbf.impl.HandlersReply;
import com.ibm.hwmca.fw.rbf.impl.RbfReply;
import com.ibm.hwmca.fw.rbf.impl.RbfUtils;
import com.ibm.hwmca.fw.system.Manager;
import com.ibm.hwmca.fw.util.Trace;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class HandlerManager {
    private static final String TRACE_MASKT = "XRBFHMGT";
    private static final String TRACE_MASKF = "XRBFHMGF";
    private static final String TRACE_MASKD = "XRBFHMGD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RBF-HndlrMgr");
    private static HandlerManager handlerManager = null;
    private boolean initialized = false;
    private Object initializeLock = new Object();
    private Map localHandlers = new HashMap();
    private Object localHandlersLock = new Object();
    private Map remoteHandlers = new HashMap();
    private Object remoteHandlersLock = new Object();
    private static final Class RBF_REQUEST_HANDLER_CLASS = class$com$ibm$hwmca$fw$rbf$RbfRequestHandler == null ? (class$com$ibm$hwmca$fw$rbf$RbfRequestHandler = HandlerManager.class$("com.ibm.hwmca.fw.rbf.RbfRequestHandler")) : class$com$ibm$hwmca$fw$rbf$RbfRequestHandler;
    private static LinkedList queue = new LinkedList();
    private static List exchangers = new ArrayList();
    private static Object exchangersLock = new Object();
    private static final int EXCHANGERS_MAX = 15;
    private static final long EXCHANGER_TIMEOUT = 120000L;
    private static final int QUEUE_BACKLOG_PER_THREAD = 2;
    private static final int HANDLERS_MSG_TIMEOUT = 180000;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$rbf$RbfRequestHandler;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$rbf$RbfRequest;

    private HandlerManager() {
        Trace.trace(TRACE_MASKT, "<> HandlerManager()");
    }

    public static synchronized HandlerManager getHandlerManager() {
        if (handlerManager == null) {
            handlerManager = new HandlerManager();
        }
        return handlerManager;
    }

    void waitUntilInitialized() {
        Trace.trace(TRACE_MASKT, "-> waitUntilInitialized()");
        Manager.getManager().waitForTowers();
        Trace.trace(TRACE_MASKT, "<- waitUntilInitialized()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerLocalHandler(Class handlerClass, RbfRequestType reqType) throws HandlerAlreadyRegisteredException, IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "-> registerLocalHandler()");
        if (handlerClass == null) {
            throw new IllegalArgumentException("Null handler class");
        }
        if (reqType == null) {
            throw new IllegalArgumentException("Null request type");
        }
        if (!RBF_REQUEST_HANDLER_CLASS.isAssignableFrom(handlerClass)) {
            String msg = handlerClass.getName() + " does not subclass " + RBF_REQUEST_HANDLER_CLASS.getName();
            throw new IllegalArgumentException(msg);
        }
        try {
            Constructor constructor = handlerClass.getConstructor(class$com$ibm$hwmca$fw$rbf$RbfRequest == null ? (class$com$ibm$hwmca$fw$rbf$RbfRequest = HandlerManager.class$("com.ibm.hwmca.fw.rbf.RbfRequest")) : class$com$ibm$hwmca$fw$rbf$RbfRequest);
        }
        catch (Exception e) {
            String msg = e.getClass().getName() + " verifying " + handlerClass.getName() + " has a public constructor taking " + (class$com$ibm$hwmca$fw$rbf$RbfRequest == null ? (class$com$ibm$hwmca$fw$rbf$RbfRequest = HandlerManager.class$("com.ibm.hwmca.fw.rbf.RbfRequest")) : class$com$ibm$hwmca$fw$rbf$RbfRequest).getName() + " as its parameter: " + e.getMessage();
            throw new IllegalArgumentException(msg);
        }
        Object object = this.localHandlersLock;
        synchronized (object) {
            if (this.localHandlers.containsKey(reqType)) {
                String msg = "A handler is already registered for " + reqType;
                throw new HandlerAlreadyRegisteredException(msg);
            }
            this.localHandlers.put(reqType, handlerClass);
        }
        Trace.trace(TRACE_MASKF, handlerClass.getName() + " registered for " + reqType);
        this.exchangeWith(CommManager.getCommManager().getPeers());
        Trace.trace(TRACE_MASKT, "<- registerLocalHandler()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterLocalHandler(RbfRequestType reqType) throws HandlerNotRegisteredException {
        Trace.trace(TRACE_MASKT, "-> deregisterLocalHandler()");
        if (reqType == null) {
            throw new IllegalArgumentException("Null request type");
        }
        Class handlerClass = null;
        Object object = this.localHandlersLock;
        synchronized (object) {
            if (!this.localHandlers.containsKey(reqType)) {
                String msg = "A handler is not registered for " + reqType;
                throw new HandlerNotRegisteredException(msg);
            }
            handlerClass = (Class)this.localHandlers.get(reqType);
            this.localHandlers.remove(reqType);
        }
        Trace.trace(TRACE_MASKF, handlerClass.getName() + " deregistered for " + reqType);
        this.exchangeWith(CommManager.getCommManager().getPeers());
        Trace.trace(TRACE_MASKT, "<- deregisterLocalHandler()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getLocalHandlerClass(RbfRequestType reqType) {
        if (reqType == null) {
            return null;
        }
        Class handlerClass = null;
        Object object = this.localHandlersLock;
        synchronized (object) {
            if (this.localHandlers.containsKey(reqType)) {
                handlerClass = (Class)this.localHandlers.get(reqType);
            } else {
                RbfRequestType closestReqType = null;
                Iterator reqTypes = this.localHandlers.keySet().iterator();
                while (reqTypes.hasNext()) {
                    RbfRequestType nextReqType = (RbfRequestType)reqTypes.next();
                    if (!nextReqType.getOwner().equals(reqType.getOwner()) || !nextReqType.getType().equals(reqType.getType()) || nextReqType.getVersion() <= reqType.getVersion() || closestReqType != null && nextReqType.getVersion() >= closestReqType.getVersion()) continue;
                    closestReqType = nextReqType;
                }
                if (closestReqType != null) {
                    handlerClass = (Class)this.localHandlers.get(closestReqType);
                }
            }
        }
        return handlerClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getHandlingMachines(RbfRequestType reqType, int reqScope) {
        HashSet<MachineId> handlers = new HashSet<MachineId>();
        if (reqType == null || reqScope == 2) {
            return handlers;
        }
        if (this.getLocalHandlerClass(reqType) != null) {
            handlers.add(FcsServer.getFcsServer().getLocalMachineId());
        }
        if (reqScope == 1) {
            Object object = this.remoteHandlersLock;
            synchronized (object) {
                Iterator remotes = this.remoteHandlers.keySet().iterator();
                while (remotes.hasNext()) {
                    MachineId remote = (MachineId)remotes.next();
                    Set remoteReqTypes = (Set)this.remoteHandlers.get(remote);
                    if (!remoteReqTypes.contains(reqType)) continue;
                    handlers.add(remote);
                }
            }
        }
        return handlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set getLocalRequestTypes() {
        HashSet localReqTypes = new HashSet();
        Object object = this.localHandlersLock;
        synchronized (object) {
            localReqTypes.addAll(this.localHandlers.keySet());
        }
        return localReqTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRemoteHandler(MachineId peer, Set reqTypes) {
        Trace.trace(TRACE_MASKT, "-> addRemoteHandler()");
        Set previousValue = null;
        Object object = this.remoteHandlersLock;
        synchronized (object) {
            previousValue = this.remoteHandlers.put(peer, reqTypes);
        }
        if (previousValue != null) {
            Trace.trace(TRACE_MASKF, "Updated remote handler: " + RbfUtils.getMachineInfo(peer) + " reqTypes=" + reqTypes.size());
        } else {
            Trace.trace(TRACE_MASKF, "Added remote handler: " + RbfUtils.getMachineInfo(peer) + " reqTypes=" + reqTypes.size());
        }
        Trace.trace(TRACE_MASKT, "<- addRemoteHandler()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRemoteHandler(MachineId peer) {
        Trace.trace(TRACE_MASKT, "-> removeRemoteHandler()");
        Object previousValue = null;
        Object object = this.remoteHandlersLock;
        synchronized (object) {
            if (this.remoteHandlers.containsKey(peer)) {
                previousValue = this.remoteHandlers.remove(peer);
            }
        }
        if (previousValue != null) {
            Trace.trace(TRACE_MASKF, "Removed remote handler: " + RbfUtils.getMachineInfo(peer));
        }
        Trace.trace(TRACE_MASKT, "<- removeRemoteHandler()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set getRemoteHandlers() {
        HashSet remotes = new HashSet();
        Object object = this.remoteHandlersLock;
        synchronized (object) {
            remotes.addAll(this.remoteHandlers.keySet());
        }
        return remotes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set getRemoteRequestTypes(MachineId peer) {
        HashSet remoteReqTypes = new HashSet();
        Object object = this.remoteHandlersLock;
        synchronized (object) {
            if (this.remoteHandlers.containsKey(peer)) {
                remoteReqTypes.addAll((Set)this.remoteHandlers.get(peer));
            }
        }
        return remoteReqTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getHandlersDump(boolean trace) {
        StringBuffer sb = new StringBuffer();
        boolean fdTrace = trace;
        sb.append("Local handlers:");
        if (fdTrace) {
            Trace.trace(TRACE_MASKF, "Local handlers:");
        }
        Object object = this.localHandlersLock;
        synchronized (object) {
            if (this.localHandlers.isEmpty()) {
                sb.append("\n   None");
                if (fdTrace) {
                    Trace.trace(TRACE_MASKF, "\n   None");
                }
            } else {
                Iterator locals = this.localHandlers.keySet().iterator();
                while (locals.hasNext()) {
                    RbfRequestType reqType = (RbfRequestType)locals.next();
                    String handler = this.localHandlers.get(reqType).toString();
                    sb.append("\n   " + reqType + " - " + handler);
                    if (!fdTrace) continue;
                    Trace.trace(TRACE_MASKF, "\n   " + reqType + " - " + handler);
                }
            }
        }
        boolean foundRemoteHandler = false;
        sb.append("\nRemote handlers:");
        if (fdTrace) {
            Trace.trace(TRACE_MASKF, "\nRemote handlers:");
        }
        Object object2 = this.remoteHandlersLock;
        synchronized (object2) {
            Iterator remotes = this.remoteHandlers.keySet().iterator();
            while (remotes.hasNext()) {
                MachineId remote = (MachineId)remotes.next();
                Set remoteReqTypes = (Set)this.remoteHandlers.get(remote);
                if (remoteReqTypes.isEmpty()) continue;
                foundRemoteHandler = true;
                String machineInfo = RbfUtils.getMachineInfo(remote);
                sb.append("\n   " + machineInfo + ":");
                if (fdTrace) {
                    Trace.trace(TRACE_MASKF, "\n   " + machineInfo + ":");
                }
                Iterator reqTypes = remoteReqTypes.iterator();
                while (reqTypes.hasNext()) {
                    String reqType = reqTypes.next().toString();
                    sb.append("\n      " + reqType);
                    if (!fdTrace) continue;
                    Trace.trace(TRACE_MASKF, "\n      " + reqType);
                }
            }
        }
        if (!foundRemoteHandler) {
            sb.append("\n   None");
            if (fdTrace) {
                Trace.trace(TRACE_MASKF, "\n   None");
            }
        }
        return sb.toString();
    }

    void fcsStateChanged(FcsEvent event) {
        MachineId localMachine = FcsServer.getFcsServer().getLocalMachineId();
        MachineId machine = event.getMachineId();
        Set services = event.getServices();
        if (!machine.equals(localMachine)) {
            int type = event.getEventType();
            int details = event.getEventDetails();
            String machineInfo = RbfUtils.getMachineInfo(machine);
            if (type == 1) {
                if (details == 51) {
                    this.exchangeWith(machine);
                } else if (details == 53) {
                    this.exchangeWith(machine);
                } else if (details == 52) {
                    this.removeRemoteHandler(machine);
                    this.exchangeNotNecessary(machine);
                } else if (details == 54) {
                    MachineId oldMachine = event.getOldMachineId();
                    this.removeRemoteHandler(oldMachine);
                    this.exchangeWith(machine);
                }
            } else if (type == 2) {
                if (details == 100) {
                    this.exchangeWith(machine);
                } else if (details == 101) {
                    this.removeRemoteHandler(machine);
                    this.exchangeNotNecessary(machine);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exchangeWith(MachineId peer) {
        Trace.trace(TRACE_MASKT, "-> exchangeWith(" + RbfUtils.getMachineInfo(peer) + ")");
        Object object = exchangersLock;
        synchronized (object) {
            int active;
            if (!queue.contains(peer)) {
                queue.add(peer);
                Trace.trace(TRACE_MASKD, this.getQueueDump());
                Trace.trace(TRACE_MASKF, queue.size() + " machines in the exchange queue");
            }
            if ((active = exchangers.size()) < 15 && queue.size() > 2 * active) {
                Exchanger exchanger = new Exchanger(new Date().toString());
                exchanger.start();
                exchangers.add(exchanger);
            }
            Trace.trace(TRACE_MASKF, exchangers.size() + " exchanger threads in existence");
            exchangersLock.notifyAll();
        }
        Trace.trace(TRACE_MASKT, "<- exchangeWith()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exchangeWith(Set peers) {
        Object object = exchangersLock;
        synchronized (object) {
            Iterator iterator = peers.iterator();
            while (iterator.hasNext()) {
                MachineId peer = (MachineId)iterator.next();
                this.exchangeWith(peer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exchangeNotNecessary(MachineId peer) {
        Object object = exchangersLock;
        synchronized (object) {
            queue.remove(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getQueueDump() {
        StringBuffer sb = new StringBuffer();
        sb.append("Handler exchange queue:\n");
        Object object = exchangersLock;
        synchronized (object) {
            if (queue.isEmpty()) {
                sb.append("1. Empty");
            } else {
                int index = 1;
                Iterator iterator = queue.iterator();
                while (iterator.hasNext()) {
                    String peer = RbfUtils.getMachineInfo((MachineId)iterator.next());
                    if (index == 1) {
                        sb.append(index + ". " + peer);
                    } else {
                        sb.append("\n" + index + ". " + peer);
                    }
                    ++index;
                }
            }
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Exchanger
    extends Thread {
        String id;
        boolean inactive = false;

        Exchanger(String id) {
            super("RBF Handler Exchanger " + id);
            this.id = id;
            Trace.trace(HandlerManager.TRACE_MASKT, "<> Exchanger " + id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Trace.trace(HandlerManager.TRACE_MASKT, "-> Exchanger " + this.id + " running");
                HandlerManager.this.waitUntilInitialized();
                while (!this.inactive) {
                    MachineId nextPeer = null;
                    long waitBegins = System.currentTimeMillis();
                    long timeToWait = 120000L;
                    Object object = exchangersLock;
                    synchronized (object) {
                        while (queue.size() <= 0 && timeToWait > 0L) {
                            try {
                                exchangersLock.wait(timeToWait);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            timeToWait = 120000L - (System.currentTimeMillis() - waitBegins);
                        }
                        if (queue.size() > 0) {
                            nextPeer = (MachineId)queue.removeFirst();
                        } else {
                            exchangers.remove(this);
                            this.inactive = true;
                        }
                    }
                    if (nextPeer == null) continue;
                    this.exchange(nextPeer);
                }
                Trace.trace(HandlerManager.TRACE_MASKT, "<- Exchanger " + this.id + " ending due to inactivity");
            }
            catch (Throwable throwable) {
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                this.getThreadGroup().uncaughtException(this, throwable);
                Object object = exchangersLock;
                synchronized (object) {
                    exchangers.remove(this);
                }
            }
        }

        private void exchange(MachineId peer) {
            block3: {
                try {
                    HandlersMsg msg = new HandlersMsg(HandlerManager.this.getLocalRequestTypes());
                    CommManager commMgr = CommManager.getCommManager();
                    RbfReply reply = commMgr.send(msg, peer, 180000);
                    if (reply instanceof HandlersReply) {
                        HandlerManager.this.addRemoteHandler(peer, ((HandlersReply)reply).getReqTypes());
                        break block3;
                    }
                    String desc = "Internal error: Invalid handlers message reply (" + reply.getClass().getName() + ") returned by " + RbfUtils.getMachineInfo(peer);
                    Trace.trace(HandlerManager.TRACE_MASKF, desc);
                    FrameworkLog fl = new FrameworkLog(classLogInfo, 1060);
                    fl.add(desc);
                    fl.add(RbfUtils.getLoggingInfo(null));
                    fl.log();
                }
                catch (RbfException rbfe) {}
            }
        }
    }
}

